package com.ejie.ab04b.dao.xa;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.DocumentoAperturas;
import com.ejie.ab04b.model.DocumentoOS2;
import com.ejie.ab04b.model.DocumentoOS3;

/**
 * SolicDocumentosDaoImpl generated by UDA, 05-May-2016 16:22:00.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class SolicDocumentosDaoXAImpl extends Ab04bTransactionalXADao implements
		SolicDocumentosDaoXA {

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource
	 *            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Method use to set the XA datasource.
	 * 
	 *  dataSourceXA
	 *            DataSource
	 *
	 * @param dataSourceXA the new data source XA
	 */
	@Resource()
	public void setDataSourceXA(DataSource dataSourceXA) {
		this.jdbcTemplateXA = new JdbcTemplate(dataSourceXA);

	}

	/**
	 * Updates a single row in the Solicitudes table.
	 * 
	 *  doc
	 *            DocumentoAperturas
	 *  DocumentoAperturas
	 *
	 * @param doc the doc
	 * @return the documento aperturas
	 */
	public DocumentoAperturas updateFilled(DocumentoAperturas doc) {
		StringBuilder query = new StringBuilder("UPDATE AB0465S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (doc != null && doc.getOidDokusi065() != null) {
			queryFields.append(" OID_DOKUSI_065 = ? ");
			params.add(doc.getOidDokusi065());
		}

		query.append(queryFields);
		query.append(" WHERE ID_DOCUMENTO_065 = ?");

		params.add(doc.getIdDocumento065());

		this.obtaninJdbcTemplateNOXA().update(query.toString(),
				params.toArray());
		return doc;
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            DocumentoAperturas
	 *  DocumentoAperturas
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the documento aperturas
	 */
	public DocumentoAperturas add(DocumentoAperturas ab0465s00) {
		String query = "INSERT INTO AB0465S00 (ID_DOCUMENTO_065, ID_TRAMITE_APERTURAS_065, ORIGEN_065, FECHA_DOC_065, RUTA_PIF_065, NOMBRE_DOC_065, OID_DOKUSI_065, ID_TIPO_DOC_065, ID_TAREA_CONT_065, ID_DATOS_ENVIO_POSTAL_065, FORMATO_APORT_065) VALUES (?,?,?,?,?,?,?,?,?,?,?)";

		// Obtenemos la secuencia
		ab0465s00.setIdDocumento065(Secuencias.DOC_APERTURAS
				.getNextLong(jdbcTemplate));

		Long idTareaCont = null;
		if (ab0465s00.getTareaAperturasContinuar() != null) {
			idTareaCont = ab0465s00.getTareaAperturasContinuar()
					.getIdTarea063();
		}

		Long idDatosEnvioPostal = null;
		if (ab0465s00.getDatosEnvioPostal() != null) {
			idTareaCont = ab0465s00.getDatosEnvioPostal()
					.getIdDatosEnvioPostal069();
		}
		Long idTipoDoc = null;
		if (ab0465s00.getTipoDocumento() != null) {
			idTipoDoc = ab0465s00.getTipoDocumento().getIdTipoDoc091();
		}
		this.obtaninJdbcTemplate().update(query, ab0465s00.getIdDocumento065(),
				ab0465s00.getTramiteAperturas().getIdTramite062(),
				ab0465s00.getOrigen065(), ab0465s00.getFechaDoc065(),
				ab0465s00.getRutaPif065(), ab0465s00.getNombreDoc065(),
				ab0465s00.getOidDokusi065(), idTipoDoc, idTareaCont,
				idDatosEnvioPostal, ab0465s00.getFormatoAport065());
		return ab0465s00;
	}

	/**
	 * Updates a single row in the Solicitudes table.
	 * 
	 *  doc
	 *            SolicDocumentos
	 *  SolicDocumentos
	 *
	 * @param doc the doc
	 * @return the documento OS 2
	 */
	public DocumentoOS2 updateFilled(DocumentoOS2 doc) {
		StringBuilder query = new StringBuilder("UPDATE AB0494S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (doc != null && doc.getOidDokusi094() != null) {
			queryFields.append(" OID_DOKUSI_094 = ? ");
			params.add(doc.getOidDokusi094());
		}

		query.append(queryFields);
		query.append(" WHERE ID_DOCUMENTO_094 = ?");

		params.add(doc.getIdDocumento094());

		this.obtaninJdbcTemplateNOXA().update(query.toString(),
				params.toArray());
		return doc;
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0494s00 table.
	 * 
	 *  ab0494s00
	 *            Ab0494s00
	 *  Ab0494s00
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @return the documento OS 2
	 */
	public DocumentoOS2 add(DocumentoOS2 ab0494s00) {
		String query = "INSERT INTO AB0494S00 (ID_DOCUMENTO_094, ID_TRAMITE_APERTURAS_094, ORIGEN_094, FECHA_DOC_094, RUTA_PIF_094, NOMBRE_DOC_094, OID_DOKUSI_094, ID_TIPO_DOC_094, ID_TAREA_CONT_094, ID_DATOS_ENVIO_POSTAL_094, FORMATO_APORT_094) VALUES (?,?,?,?,?,?,?,?,?,?,?)";

		// Obtenemos la secuencia
		ab0494s00.setIdDocumento094(Secuencias.DOC_OS2
				.getNextLong(jdbcTemplate));

		Long idTareaCont = null;
		if (ab0494s00.getTareaOS2Continuar() != null) {
			idTareaCont = ab0494s00.getTareaOS2Continuar().getIdTarea093();
		}

		Long idDatosEnvioPostal = null;
		if (ab0494s00.getDatosEnvioPostal() != null) {
			idTareaCont = ab0494s00.getDatosEnvioPostal()
					.getIdDatosEnvioPostal069();
		}
		Long idTipoDoc = null;
		if (ab0494s00.getTipoDocumento() != null) {
			idTipoDoc = ab0494s00.getTipoDocumento().getIdTipoDoc091();
		}
		this.obtaninJdbcTemplate().update(query, ab0494s00.getIdDocumento094(),
				ab0494s00.getTramiteOS2().getIdTramite092(),
				ab0494s00.getOrigen094(), ab0494s00.getFechaDoc094(),
				ab0494s00.getRutaPif094(), ab0494s00.getNombreDoc094(),
				ab0494s00.getOidDokusi094(), idTipoDoc, idTareaCont,
				idDatosEnvioPostal, ab0494s00.getFormatoAport094());
		return ab0494s00;
	}

	/**
	 * Updates a single row in the Solicitudes table.
	 * 
	 *  doc
	 *            SolicDocumentos
	 *  SolicDocumentos
	 *
	 * @param doc the doc
	 * @return the documento OS 3
	 */
	public DocumentoOS3 updateFilled(DocumentoOS3 doc) {
		StringBuilder query = new StringBuilder("UPDATE AB0497S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (doc != null && doc.getOidDokusi097() != null) {
			queryFields.append(" OID_DOKUSI_097 = ? ");
			params.add(doc.getOidDokusi097());
		}

		query.append(queryFields);
		query.append(" WHERE ID_DOCUMENTO_097 = ?");

		params.add(doc.getIdDocumento097());

		this.obtaninJdbcTemplateNOXA().update(query.toString(),
				params.toArray());
		return doc;
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0497s00 table.
	 * 
	 *  ab0497s00
	 *            Ab0497s00
	 *  Ab0497s00
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @return the documento OS 3
	 */
	public DocumentoOS3 add(DocumentoOS3 ab0497s00) {
		String query = "INSERT INTO AB0497S00 (ID_DOCUMENTO_097, ID_TRAMITE_APERTURAS_097, ORIGEN_097, FECHA_DOC_097, RUTA_PIF_097, NOMBRE_DOC_097, OID_DOKUSI_097, ID_TIPO_DOC_097, ID_TAREA_CONT_097, ID_DATOS_ENVIO_POSTAL_097, FORMATO_APORT_097) VALUES (?,?,?,?,?,?,?,?,?,?,?)";

		// Obtenemos la secuencia
		ab0497s00.setIdDocumento097(Secuencias.DOC_OS3
				.getNextLong(jdbcTemplate));

		Long idTareaCont = null;
		if (ab0497s00.getTareaOS3Continuar() != null) {
			idTareaCont = ab0497s00.getTareaOS3Continuar().getIdTarea096();
		}

		Long idDatosEnvioPostal = null;
		if (ab0497s00.getDatosEnvioPostal() != null) {
			idTareaCont = ab0497s00.getDatosEnvioPostal()
					.getIdDatosEnvioPostal069();
		}
		Long idTipoDoc = null;
		if (ab0497s00.getTipoDocumento() != null) {
			idTipoDoc = ab0497s00.getTipoDocumento().getIdTipoDoc091();
		}
		this.obtaninJdbcTemplate().update(query, ab0497s00.getIdDocumento097(),
				ab0497s00.getTramiteOS3().getIdTramite095(),
				ab0497s00.getOrigen097(), ab0497s00.getFechaDoc097(),
				ab0497s00.getRutaPif097(), ab0497s00.getNombreDoc097(),
				ab0497s00.getOidDokusi097(), idTipoDoc, idTareaCont,
				idDatosEnvioPostal, ab0497s00.getFormatoAport097());
		return ab0497s00;
	}

}
